;(function($) {
"use strict";

    /*
    * Plugin Installation Manager
    */
    var HTpmtemplataPluginManager = {

        init: function(){
            $( document ).on('click','.install-now', HTpmtemplataPluginManager.installNow );
            $( document ).on('click','.activate-now', HTpmtemplataPluginManager.activatePlugin);
            $( document ).on('wp-plugin-install-success', HTpmtemplataPluginManager.installingSuccess);
            $( document ).on('wp-plugin-install-error', HTpmtemplataPluginManager.installingError);
            $( document ).on('wp-plugin-installing', HTpmtemplataPluginManager.installingProcess);
        },

        /**
         * Installation Error.
         */
        installingError: function( e, response ) {
            e.preventDefault();
            var $card = $( '.htwptemplata-plugin-' + response.slug );
            $button = $card.find( '.button' );
            $button.removeClass( 'button-primary' ).addClass( 'disabled' ).html( wp.updates.l10n.installFailedShort );
        },

        /**
         * Installing Process
         */
        installingProcess: function(e, args){
            e.preventDefault();
            var $card = $( '.htwptemplata-plugin-' + args.slug ),
                $button = $card.find( '.button' );
                $button.text( HTPMM.buttontxt.installing ).addClass( 'updating-message' );
        },

        /**
        * Plugin Install Now
        */
        installNow: function(e){
            e.preventDefault();

            var $button = $( e.target ),
                $plugindata = $button.data('pluginopt');

            if ( $button.hasClass( 'updating-message' ) || $button.hasClass( 'button-disabled' ) ) {
                return;
            }
            if ( wp.updates.shouldRequestFilesystemCredentials && ! wp.updates.ajaxLocked ) {
                wp.updates.requestFilesystemCredentials( e );
                $( document ).on( 'credential-modal-cancel', function() {
                    var $message = $( '.install-now.updating-message' );
                    $message.removeClass( 'updating-message' ).text( wp.updates.l10n.installNow );
                    wp.a11y.speak( wp.updates.l10n.updateCancel, 'polite' );
                });
            }
            wp.updates.installPlugin( {
                slug: $plugindata['slug']
            });

        },

        /**
         * After Plugin Install success
         */
        installingSuccess: function( e, response ) {
            var $message = $( '.htwptemplata-plugin-' + response.slug ).find( '.button' );

            var $plugindata = $message.data('pluginopt');

            $message.removeClass( 'install-now installed button-disabled updated-message' )
                .addClass( 'updating-message' )
                .html( HTPMM.buttontxt.activating );

            setTimeout( function() {
                $.ajax( {
                    url: HTPMM.ajaxurl,
                    type: 'POST',
                    data: {
                        action   : 'htpm_ajax_plugin_activation',
                        location : $plugindata['location'],
                    },
                } ).done( function( result ) {
                    if ( result.success ) {
                        $message.removeClass( 'button-primary install-now activate-now updating-message' )
                            .attr( 'disabled', 'disabled' )
                            .addClass( 'disabled' )
                            .text( HTPMM.buttontxt.active );

                    } else {
                        $message.removeClass( 'updating-message' );
                    }

                });

            }, 1200 );

        },

        /**
         * Plugin Activate
         */
        activatePlugin: function( e, response ) {
            e.preventDefault();

            var $button = $( e.target ),
                $plugindata = $button.data('pluginopt');

            if ( $button.hasClass( 'updating-message' ) || $button.hasClass( 'button-disabled' ) ) {
                return;
            }

            $button.addClass( 'updating-message button-primary' ).html( HTPMM.buttontxt.activating );

            $.ajax( {
                url: HTPMM.ajaxurl,
                type: 'POST',
                data: {
                    action   : 'htpm_ajax_plugin_activation',
                    location : $plugindata['location'],
                },
            }).done( function( response ) {
                if ( response.success ) {
                    $button.removeClass( 'button-primary install-now activate-now updating-message' )
                        .attr( 'disabled', 'disabled' )
                        .addClass( 'disabled' )
                        .text( HTPMM.buttontxt.active );
                }
            });

        },

        
    };

   

    /**
     * Initialize HTpmtemplataPluginManager
     */
    $( document ).ready( function() {
        HTpmtemplataPluginManager.init();
    });

})(jQuery);