<?php
get_header(); ?>
    <div class="wrap">
        <div id="primary" class="content-area">
            <main id="main" class="site-main">
                <section class="error-404 not-found">
                    <div class="page-content">
                        <div class="row">
                            <div class="col-12 error-404-content text-center">
                                <h1 class="error-title p-0 m-0"><?php esc_html_e('It looks like you’re lost...', 'startor'); ?></h1>
                                <div class="error-404-bkg">
                                    <img src="<?php echo get_theme_file_uri('assets/images/404.png') ?>" alt="<?php echo esc_attr__('404 Page', 'startor') ?>">
                                </div>
                                <div class="error-content">
                                    <div class="error-text">
                                        <span><?php esc_html_e("It looks like nothing was found at this location. You can either go back to the last page or go to homepage.", 'startor') ?></span>
                                    </div>
                                    <div class="error-btn-bh">
                                        <a href="javascript: history.go(-1)"
                                           class="go-back"><?php esc_html_e('Go Back', 'startor'); ?></a>
                                        <a href="<?php echo esc_url(home_url('/')); ?>"
                                           class="return-home"><?php esc_html_e('Homepage', 'startor'); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- .page-content -->
                </section><!-- .error-404 -->
            </main><!-- #main -->
        </div><!-- #primary -->
    </div><!-- .wrap -->
<?php get_footer();
